import { StarXpandCommand } from "star-io10-web";

export class LabelSample11_For203dpiAnd300dpi_ShippingAddressLabel {
  static async createPrintCommands(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder().addPrinter(
        new StarXpandCommand.PrinterBuilder()
          .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
          .styleMagnification(new StarXpandCommand.MagnificationParameter(2, 2))
          .actionPrintText("FAO:John Smith\n")
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleBold(true)
              .actionPrintText("Star Clothing Boutique\n"),
          )
          .actionPrintText("123 Star Road, City,\nState 12345\n")
          .styleBold(true)
          .actionPrintText("U.S.A\n")
          .actionCut(StarXpandCommand.Printer.CutType.Partial),
      ),
    );

    return await builder.getCommands();
  }
}
